﻿var modifyQuota = {
    context: $(".v-modifyQuota"),
    initialize: function () {
        var rows = a4.parent().quotas.datatable.a4datatable("getRowsData");
        var rowsSelected = a4.parent().quotas.datatable.a4datatable("getSelectedItems");

        var stratas = [];
        var stratasSelected = [];

        _.each(rows, function (row) {
            stratas.push(row.Id);
        });
        _.each(rowsSelected, function (row) {
            stratasSelected.push(row.Id);
        });

        $("#Stratas").val(stratas.join(','));
        $("#StratasSelected").val(stratasSelected.join(','));
    },
    binEvents: function () {       
        modifyQuota.context.on("change", "input[name='QuotaActionStatus']", function () {
            modifyQuota.verifyDivideByZero($(this));
        });

        modifyQuota.context.on("change", "#QuotaObjective", function () {
            modifyQuota.verifyDivideByZero($("input[name='QuotaActionStatus']:checked"));
        });
    },
    verifyDivideByZero: function (operationObj) {
        if ($(operationObj).val() === "Divide" && $("#QuotaObjective").val() == 0) {
            $("#QuotaObjective").val("");
            a4.showErrorMessage(resources.ErrorDivideByZero);
        }
    }
}

$(document).ready(function () {
    if (modifyQuota.context.length > 0) {
        modifyQuota.initialize();
        modifyQuota.binEvents();
    }
});